/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class BlockTypeRegistry<T extends BlockType> {
    protected boolean frozen = false;
    private final String name;
    private final List<BlockType.SetFinder<T>> finders = new ArrayList<BlockType.SetFinder<T>>();
    private final Set<class_2960> notInclude = new HashSet<class_2960>();
    private final MapRegistry<T> valuesReg;
    private final Class<T> typeClass;
    private final Object2ObjectOpenHashMap<Object, T> childrenToType = new Object2ObjectOpenHashMap();

    public static Codec<BlockTypeRegistry<?>> getRegistryCodec() {
        return BlockSetInternal.getRegistriesCodec();
    }

    protected BlockTypeRegistry(Class<T> typeClass, String name) {
        this.typeClass = typeClass;
        this.name = name;
        this.valuesReg = new MapRegistry(name);
    }

    public Class<T> getType() {
        return this.typeClass;
    }

    @Deprecated(forRemoval=true)
    public T getFromNBT(String name) {
        return (T)((BlockType)this.valuesReg.getValueOrDefault(new class_2960(name), this.getDefaultType()));
    }

    @Nullable
    public T get(class_2960 res) {
        return (T)((BlockType)this.valuesReg.getValue(res));
    }

    public class_2960 getKey(T input) {
        return this.valuesReg.getKey(input);
    }

    public Codec<T> getCodec() {
        return this.valuesReg;
    }

    public abstract T getDefaultType();

    public Collection<T> getValues() {
        return this.valuesReg.getValues();
    }

    public String typeName() {
        return this.name;
    }

    public abstract Optional<T> detectTypeFromBlock(class_2248 var1, class_2960 var2);

    public void registerBlockType(T newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a wood types after registry events");
        }
        if (!this.valuesReg.containsKey(((BlockType)newType).id)) {
            this.valuesReg.register(((BlockType)newType).id, newType);
        }
    }

    public Collection<BlockType.SetFinder<T>> getFinders() {
        return this.finders;
    }

    public void addFinder(BlockType.SetFinder<T> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a block type finder after registry events");
        }
        this.finders.add(finder);
    }

    public void addRemover(class_2960 id) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        this.notInclude.add(id);
    }

    protected void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        this.frozen = true;
    }

    @ApiStatus.Internal
    public void onBlockInit() {
        this.getValues().forEach(BlockType::initializeChildrenBlocks);
    }

    @ApiStatus.Internal
    public void onItemInit() {
        this.getValues().forEach(BlockType::initializeChildrenItems);
    }

    @ApiStatus.Internal
    public void buildAll() {
        if (!this.frozen) {
            T defaultType = this.getDefaultType();
            if (defaultType != null) {
                this.registerBlockType(defaultType);
            }
            this.finders.stream().map(BlockType.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
            for (class_2248 b : class_7923.field_41175) {
                this.detectTypeFromBlock(b, Utils.getID(b)).ifPresent(t -> {
                    if (!this.notInclude.contains(t.getId())) {
                        this.registerBlockType(t);
                    }
                });
            }
            this.finders.clear();
            this.notInclude.clear();
            this.finalizeAndFreeze();
        }
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
    }

    @Nullable
    public T getBlockTypeOf(class_1935 itemLike) {
        class_1747 bi;
        BlockType ofBlock;
        BlockType t = (BlockType)this.childrenToType.get((Object)itemLike);
        if (t != null) {
            return (T)t;
        }
        if (itemLike == class_1802.field_8162 || itemLike == class_2246.field_10124) {
            return null;
        }
        if (itemLike instanceof class_1747 && (ofBlock = (BlockType)this.childrenToType.get((Object)(bi = (class_1747)itemLike).method_7711())) != null) {
            return (T)ofBlock;
        }
        if (itemLike instanceof class_2248) {
            class_2248 b = (class_2248)itemLike;
            class_1792 item = b.method_8389();
            if (item == class_1802.field_8162) {
                return null;
            }
            return (T)((BlockType)this.childrenToType.get((Object)item));
        }
        return null;
    }

    protected void mapObjectToType(Object itemLike, BlockType type) {
        class_1747 bi;
        this.childrenToType.put(itemLike, (Object)type);
        if (itemLike instanceof class_1747 && !this.childrenToType.containsKey((Object)(bi = (class_1747)itemLike).method_7711())) {
            this.childrenToType.put((Object)bi.method_7711(), (Object)type);
        }
    }

    public int priority() {
        return 100;
    }
}

